<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('municipios_users', function (Blueprint $table) {
            $table->foreignId('municipio_id')->constrained()->cascadeOnDelete(); //
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(); // 
            $table->timestamps();
            $table->primary(['municipio_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('municipios_users');
    }
};
